﻿/*
 * Created by SharpDevelop.
 * User: User
 * Date: 22/10/2012
 * Time: 11.43
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.IO;
using System.Security.Cryptography;
using System.Drawing;
using System.Data.SQLite;
using System.Linq;


namespace MainProject.Libs
{
	/// <summary>
	/// Description of Strings.
	/// </summary>
	public static class CustomExtension
	{
        // ********************************************************************
        //          FILETYPE
        // ********************************************************************

        public static bool IsImage(this fileType source) {
        	return (source == fileType.Bmp || source == fileType.Png || source == fileType.Jpeg || source == fileType.Tiff);
        }
        
        public static bool IsOffice(this fileType source) {
        	return (source == fileType.Docx || source == fileType.Xlsx || source == fileType.Odt || source == fileType.Ods);
        }

        // ********************************************************************
        //          STRINGS
        // ********************************************************************

        public static bool In(this string source, params string[] args) {
        	return args.Contains(source);
        }

        public static string FormatWith(this string source, params object[] args) {
            return string.Format(source, args);
        }

        public static string ToUnixPath(this string source) {
        	if (source.Length > 2 && source.Substring(1,1) == ":") source = source.Substring(2);	// remove the drive letter, like C:
        	return source.Replace("\\","/");
        }

        public static string ToSql(this string source) {
        	return "'" + source.Replace("'","''") + "'";
        }

        public static string ToHex(this string s) {
	    	string res = string.Empty;
	    	for (int i = 0; i < s.Length; ++i) {
	    		res += (Convert.ToByte(Convert.ToChar(s.Substring(i, 1)))).ToString("X").PadLeft(2, '0') + " ";
	    	}
	    	return res.Trim();
	    }

        public static string RemoveLast(this string source) {
        	if (source.Length == 0) return string.Empty;
        	return source.Remove(source.Length -1);
        }

        public static string FromExifDate(this string source) {
        	if (source.Length <= 8) return source;
        	return source.Substring(0,4) + "-" + source.Substring(5,2) + "-" + source.Substring(8);
        }

        public static int LevenshteinDistance(this string s, string t) {
			//distance between 2 strings: how many changes are needed to transform s into t
			
			int n = s.Length; 
			int m = t.Length; 
			int[,] d = new int[n + 1, m + 1]; // matrix
			int cost; // cost

			// data validation
			if(n == 0) return m;
			if(m == 0) return n;
			
			// matrix init
			for(int i = 0; i <= n; d[i, 0] = ++i);
			for(int j = 0; j <= m; d[0, j] = ++j);
			
			for(int i = 1; i <= n; ++i) {
				for(int j = 1; j <= m; ++j) {
					cost = (t.Substring(j - 1, 1) == s.Substring(i - 1, 1) ? 0 : 1);
					d[i, j] = System.Math.Min(System.Math.Min(d[i - 1, j] + 1, d[i, j - 1] + 1), d[i - 1, j - 1] + cost);
				}
			}
			 
			// return distance
			return d[n, m];
		}

        public static ushort ToUShort(this string source, ushort defValue = 0, float scale = 1F, bool validOrReplace = true) {
            float res = 0;
            if (!float.TryParse(source, out res)) {
                res = (ushort) defValue;
                if (validOrReplace) source = defValue.ToString();
            } else {
                res = (res * scale);
            }
            return (ushort) res;
        }

        public static short ToShort(this string source, short defValue = 0, float scale = 1F, bool validOrReplace = true) {
            float res = 0;
            if (!float.TryParse(source, out res)) {
                res = (short) defValue;
                if (validOrReplace) source = defValue.ToString();
            } else {
                res = (res * scale);
            }
            return (short) res;
        }

        public static int ToInt(this string source, int defValue = 0, float scale = 1F, bool validOrReplace = true) {
            float res = 0;
            if (!float.TryParse(source, out res)) {
                res = (int) defValue;
                if (validOrReplace) source = defValue.ToString();
            } else {
                res = (res * scale);
            }
            return (int) res;
        }

        public static long ToLong(this string source, long defValue = 0, float scale = 1F, bool validOrReplace = true) {
            long res = 0;
            if (!long.TryParse(source, out res)) {
                res = defValue;
                if (validOrReplace) source = defValue.ToString();
            } else {
                res = (long)(res * scale);
            }
            return res;
        }

        public static float ToFloat(this string source, float defValue = 0F, bool validOrReplace = true) {
            float res = 0;
            if (!float.TryParse(source, out res)) {
                res = defValue;
                if (validOrReplace) source = defValue.ToString("#0.00");
            }
            return res;
        }

        public static double ToDouble(this string source, double defValue = 0D, bool validOrReplace = true) {
            double res = 0;
            if (!double.TryParse(source, out res)) {
                res = defValue;
                if (validOrReplace) source = defValue.ToString("#0.00");
            }
            return res;
        }

        // ********************************************************************
        //          SQLITE REGEXP SUPPORT
        // ********************************************************************

        public static void BindFunction(this SQLiteConnection connection, SQLiteFunction function)
		{
		    var attributes = function.GetType().GetCustomAttributes(typeof(SQLiteFunctionAttribute), true).Cast<SQLiteFunctionAttribute>().ToArray();
		    if (attributes.Length == 0) {
		        throw new InvalidOperationException("SQLiteFunction doesn't have SQLiteFunctionAttribute");
		    }
		    connection.BindFunction(attributes[0], function);
		}

        // ********************************************************************
        //          BITMAP
        // ********************************************************************

        public static int ColorDepth(this Bitmap bmp) {
            return Image.GetPixelFormatSize(bmp.PixelFormat);
        }



    }



}
