using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Threading;
using System.IO;
using System.Security.Cryptography;

namespace MainProject.Libs
{
	public enum fileType {
		Jpeg,
		Tiff,
		Png,
		Bmp,
		Pdf,
		Odt,
		Ods,
		Docx,
		Xlsx,
		Xlsm,
		Unknow
	}


	public static class cIO
    {
        
		public static string MakeValidFileName( string name )
		{
		   string invalidChars = Regex.Escape( new string( Path.GetInvalidFileNameChars() ) );
		   string invalidReStr = string.Format( @"[{0}]+", invalidChars );
		   return Regex.Replace( name, invalidReStr, "_" );
		}
        
		public static string GetFileMd5(string f) {
			// Init
			MD5 md5 = MD5.Create();
			int readCount = 0;
			byte[] buffer = new byte[1000000];		
			
			if (!File.Exists(f)) return string.Empty;
			
			using (FileStream fs = new FileStream(f, FileMode.Open, FileAccess.Read)) {
				// For each block:
				while ((readCount = fs.Read(buffer, 0, buffer.Length)) > 0)
				        md5.TransformBlock(buffer, 0, readCount, buffer, 0);
			    md5.TransformFinalBlock(buffer, 0, readCount);
			    fs.Close();
			    fs.Dispose();
			}
			
			// Get the has code
			byte[] hash = md5.Hash;
			
			string res = string.Empty;
			for (int i = 0; i < hash.Length; ++i) res += hash[i].ToString("X2");
			return res;
		}
        
    }


}
