﻿/*
 * Created by SharpDevelop.
 * User: utente
 * Date: 10/6/2016
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Xml;
using System.Globalization;
using System.Collections;
using System.Collections.Generic;
using System.Reflection;
using System.IO;


namespace MainProject.Libs
{
	/// <summary>
	/// Description of Language.
	/// </summary>
	public static class cLang
	{
		public static CultureInfo ci = CultureInfo.InstalledUICulture;
		private static Dictionary<string, string> _ml = new Dictionary<string, string>();

		public static string Lang {
			get {
				return ci.TwoLetterISOLanguageName.ToLower();
			}
		}
		
		public static void LoadML() {
			//local xml translations
			var sr = new StreamReader(Assembly.GetExecutingAssembly().GetManifestResourceStream("lang_xml"));
			XmlDocument mDoc = new XmlDocument();
			mDoc.LoadXml(sr.ReadToEnd());
			sr.Close();
			sr.Dispose();
			
			_ml.Clear();
			foreach (XmlNode txt in mDoc.SelectNodes("/texts/text")) {
				if (txt.Attributes.GetNamedItem(Lang) != null) {
					_ml.Add(txt.Attributes.GetNamedItem("k").InnerText, txt.Attributes.GetNamedItem(Lang).InnerText);
				} else {
					_ml.Add(txt.Attributes.GetNamedItem("k").InnerText, txt.Attributes.GetNamedItem("en").InnerText);
				}
			}
		}

		public static string ML(string k) {
			return _ml[k] ?? string.Empty;
		}


	}
}
