using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.IO;


namespace MainProject.Libs
{
    public static class cProcess
    {
        public static bool IsIde()
        {
            //are in Debug Mode?
            return System.Diagnostics.Debugger.IsAttached;
        }
        public static bool IsDesign(Form frm)
        {
            //are in Design Mode?
            return (frm.Site != null && frm.Site.DesignMode == true);
        }
        public static bool IsDesign(UserControl uc)
        {
            //are in Design Mode?
            return (uc.Site != null && uc.Site.DesignMode == true);
        }
        public static bool IsDesign(PictureBox pb)
        {
            //are in Design Mode?
            return (pb.Site != null && pb.Site.DesignMode == true);
        }

        public static string Run(string exeFile, string parameters, int timeout, bool readOutput = false, bool shellExec = false) {
        	ProcessStartInfo startInfo = new ProcessStartInfo();
			Process p = new Process();
			string res = string.Empty;
			
			startInfo.CreateNoWindow = true;
			startInfo.RedirectStandardOutput = !shellExec;
			
			startInfo.UseShellExecute = shellExec;			
			startInfo.FileName = exeFile;
			startInfo.Arguments = parameters;
			p.StartInfo = startInfo;
			
			p.Start();
			
			//don't wait
			if (timeout == -2) return res;
			if (readOutput) res = p.StandardOutput.ReadToEnd();

			//try-catch is needed because a process can exit immediately
			//and myProc become NULL throwing an exception
			try {
				if (timeout == -1) {
					p.WaitForExit();
				} else {
					p.WaitForExit(timeout);
				}
			} catch {}
			
			return res;
		}

        public static bool AsyncRun(string exeFile, string parameters, bool shellExec = false) {
			try {
	        	ProcessStartInfo startInfo = new ProcessStartInfo();
				Process p = new Process();
				string res = string.Empty;
				
				startInfo.CreateNoWindow = true;
				startInfo.UseShellExecute = shellExec;			
				startInfo.FileName = exeFile;
				startInfo.Arguments = parameters;
				p.StartInfo = startInfo;
				
				p.Start();
				
				return true;
        	} catch {
        		return false;
        	}
		}
        
        
        public static string RunGetOutput(string exeFile, string parameters, ref byte[] buffer) {
        	StringBuilder res = new StringBuilder();
        	ProcessStartInfo startInfo = new ProcessStartInfo();
			Process p = new Process();
			
			startInfo.CreateNoWindow = true;
			startInfo.RedirectStandardOutput = true;
			startInfo.RedirectStandardInput = true;
			
			startInfo.UseShellExecute = false;			
			startInfo.FileName = exeFile;
			startInfo.Arguments = parameters;
			p.StartInfo = startInfo;
			
			p.Start();
			p.StandardInput.BaseStream.Write(buffer,0, buffer.Length);
			p.StandardInput.Flush();
			p.StandardInput.Close();
			
			while (!p.HasExited) {
				res.Append(p.StandardOutput.ReadToEnd());
			}
			
			return res.ToString();
		}

        public static string[] GetList() {
        	Process[] pList = Process.GetProcesses();
        	string[] res = new string[pList.Length];
        	
        	for (int i = 0; i < pList.Length; ++i) res[i] = pList[i].ProcessName;
        	return res;
        }

        public static string[] GetListByName(string procname) {
        	Process[] pList = Process.GetProcessesByName(procname);
        	string[] res = new string[pList.Length];
        	
        	for (int i = 0; i < pList.Length; ++i) res[i] = pList[i].ProcessName;
        	return res;
        }
        
        public static bool IsRunning (string procname) {
        	procname = procname.ToLower();
        	foreach(Process myProc in Process.GetProcesses()) {
        		if (myProc.ProcessName.ToLower().Contains(procname)) return true;
        	}
        	return false;
        }
        
        public static bool Kill(string procname, bool onlyFirstInstance) {
        	// procname is the executable name WITHOUT .exe extension
        	bool res = false;
        	foreach(Process myProc in Process.GetProcesses()) {
        		if (myProc.ProcessName.StartsWith(procname) && myProc.Id != Process.GetCurrentProcess().Id) {
        			myProc.Kill();
        			res = true;
        			if (onlyFirstInstance) return res;
        		}
        	}
        	return res;
        }

        public static bool Find(string procname, bool insideText) {
        	// procname is the executable name WITHOUT .exe extension
			// procname can be a part of the executable name
        	foreach(Process myProc in Process.GetProcesses()) {
        		if (insideText) {
	        		if (myProc.ProcessName.IndexOf(procname) >= 0) return true;
        		} else {
	        		if (myProc.ProcessName.StartsWith(procname)) return true;
        		}
        	}
        	return false;
        }

        
    }
}
