﻿/*
 * Created by SharpDevelop.
 * User: utente
 * Date: 10/3/2016
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Data.SQLite;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;

namespace MainProject.Libs
{
	[SQLiteFunction(Name = "REGEXP", Arguments = 2, FuncType = FunctionType.Scalar)]
	public class SQLiteRegexp : SQLiteFunction
	{
	   public override object Invoke(object[] args)
	   {
	      return Regex.IsMatch(Convert.ToString(args[1]),Convert.ToString(args[0]));
	   }
	}

	[SQLiteFunction(Name = "GetFileName", Arguments = 1, FuncType = FunctionType.Scalar)]
	public class SQLiteGetFileName : SQLiteFunction
	{
	   public override object Invoke(object[] args)
	   {
	      return Path.GetFileName(Convert.ToString(args[0]));
	   }
	}

	[SQLiteFunction(Name = "GetFileNameWithoutExt", Arguments = 1, FuncType = FunctionType.Scalar)]
	public class SQLiteGetFileNameWithoutExt : SQLiteFunction
	{
	   public override object Invoke(object[] args)
	   {
	      return Path.GetFileNameWithoutExtension(Convert.ToString(args[0]));
	   }
	}

}
