; Script generated by the HM NIS Edit Script Wizard.
; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "DataSearch"
!define PRODUCT_VERSION "1.1"
!define PRODUCT_PUBLISHER "Stefano Fraccaro"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

RequestExecutionLevel user

; MUI 1.67 compatible ------
!include "MUI.nsh"
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"


; Welcome page
!insertmacro MUI_PAGE_WELCOME
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Italian"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "DataSearch_Setup.exe"
InstallDir "$APPDATA\DataSearch"
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Section "SezionePrincipale" SEC01
  SetOverwrite on
  CreateDirectory "$INSTDIR"
  CreateDirectory "$INSTDIR\x86"
  CreateDirectory "$INSTDIR\x64"
  
  ;CARTELLA TESSERACT
  CreateDirectory "$INSTDIR\Tesseract"
  SetOutPath "$INSTDIR\Tesseract"
  File "..\Varie\Tesseract\*.*"

  CreateDirectory "$INSTDIR\Tesseract\java"
  SetOutPath "$INSTDIR\Tesseract\java"
  File "..\Varie\Tesseract\java\*.*"

  CreateDirectory "$INSTDIR\Tesseract\doc"
  SetOutPath "$INSTDIR\Tesseract\doc"
  File "..\Varie\Tesseract\doc\*.*"

  CreateDirectory "$INSTDIR\Tesseract\tessdata"
  SetOutPath "$INSTDIR\Tesseract\tessdata"
  File "..\Varie\Tesseract\tessdata\*.*"
  
  CreateDirectory "$INSTDIR\Tesseract\tessdata\configs"
  SetOutPath "$INSTDIR\Tesseract\tessdata\configs"
  File "..\Varie\Tesseract\tessdata\configs\*.*"

  CreateDirectory "$INSTDIR\Tesseract\tessdata\tessconfigs"
  SetOutPath "$INSTDIR\Tesseract\tessdata\tessconfigs"
  File "..\Varie\Tesseract\tessdata\tessconfigs\*.*"

  ;CARTELLA DataSearch
  SetOutPath "$INSTDIR"
  File "..\gpl-3.0.txt"
  File "..\Varie\BarcodeImaging3\barcode_license.htm"
  File "..\MainProject\bin\Debug\*.exe"
  File "..\MainProject\bin\Debug\*.dll"
  File "..\MainProject\bin\Debug\*.ico"
  File "..\MainProject\bin\Debug\*.xml"
  File "..\MainProject\bin\Debug\*.txt"
  File "..\MainProject\bin\Debug\*.config"

  SetOutPath "$INSTDIR\x86"
  File "..\MainProject\bin\Debug\x86\*.*"
  SetOutPath "$INSTDIR\x64"
  File "..\MainProject\bin\Debug\x64\*.*"

  ;DATABASE
  SetOutPath "$INSTDIR"
  SetOverwrite off
  File "..\MainProject\bin\Debug\*.sqlite"
  
  ;SetShellVarContext all
  SetOverwrite on
  SetShellVarContext current
  CreateShortCut "$DESKTOP\DataSearch.lnk" "$INSTDIR\DataSearch.exe" "" "$INSTDIR\find.ico"

  SetOutPath "$INSTDIR"

SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\find.ico"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name)  stato completamente rimosso dal tuo computer."
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Sei sicuro di voler completamente rimuovere $(^Name) e tutti i suoi componenti?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  SetShellVarContext all

  Delete "$DESKTOP\DataSearch.lnk"

  RMDir /r /REBOOTOK "$INSTDIR"

  SetAutoClose true
SectionEnd
