; Script generated by the HM NIS Edit Script Wizard.
; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "DataSearch"
!define PRODUCT_VERSION "1.0"
!define PRODUCT_PUBLISHER "Stefano Fraccaro"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Italian"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "DataSearch_Update.exe"
InstallDir "$PROGRAMFILES\DataSearch"
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Section "SezionePrincipale" SEC01
  SetOverwrite on
  CreateDirectory "$INSTDIR"
  CreateDirectory "$INSTDIR\x86"
  CreateDirectory "$INSTDIR\x64"
  
  ;CARTELLA DataSearch
  SetOutPath "$INSTDIR"
  File "..\gpl-3.0.txt"
  File "..\Varie\BarcodeImaging3\barcode_license.htm"
  File "..\MainProject\bin\Debug\*.exe"
  File "..\MainProject\bin\Debug\*.dll"
  File "..\MainProject\bin\Debug\*.ico"
  File "..\MainProject\bin\Debug\*.xml"
  File "..\MainProject\bin\Debug\*.txt"
  File "..\MainProject\bin\Debug\*.config"

  SetOutPath "$INSTDIR\x86"
  File "..\MainProject\bin\Debug\x86\*.*"
  SetOutPath "$INSTDIR\x64"
  File "..\MainProject\bin\Debug\x64\*.*"

  ;DATABASE
  SetOutPath "$INSTDIR"
  SetOverwrite off
  File "..\MainProject\bin\Debug\*.sqlite"
  
  ;SetShellVarContext all
  SetOverwrite on
  SetShellVarContext current
  CreateShortCut "$SMPROGRAMS\DataSearch.lnk" "$INSTDIR\DataSearch.exe" "" "$INSTDIR\find.ico"
  CreateShortCut "$DESKTOP\DataSearch.lnk" "$INSTDIR\DataSearch.exe" "" "$INSTDIR\find.ico"

  SetOutPath "$INSTDIR"

SectionEnd

Section -AdditionalIcons

SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\DataSearch.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name)  stato completamente rimosso dal tuo computer."
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Sei sicuro di voler completamente rimuovere $(^Name) e tutti i suoi componenti?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  SetShellVarContext all

  Delete "$INSTDIR\*.*"
  Delete "$INSTDIR\x86\*.*"
  Delete "$INSTDIR\x64\*.*"
  Delete "$INSTDIR\TesserAct\*.*"
  Delete "$INSTDIR\TesserAct\java\*.*"
  Delete "$INSTDIR\TesserAct\doc\*.*"
  Delete "$INSTDIR\TesserAct\tessdata\*.*"
  Delete "$INSTDIR\TesserAct\tessdata\configs\*.*"
  Delete "$INSTDIR\TesserAct\tessdata\tessconfigs\*.*"
  
  Delete "$SMPROGRAMS\DataSearch.lnk"
  Delete "$DESKTOP\DataSearch.lnk"

  RMDir "$INSTDIR\TesserAct\tessdata\configs"
  RMDir "$INSTDIR\TesserAct\tessdata\tessconfigs"
  RMDir "$INSTDIR\TesserAct\tessdata"
  RMDir "$INSTDIR\TesserAct\java"
  RMDir "$INSTDIR\TesserAct\doc"
  RMDir "$INSTDIR\TesserAct"
  RMDir "$INSTDIR\x86"
  RMDir "$INSTDIR\x64"
  RMDir "$INSTDIR"

  
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd