#     This program is free software: you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation, either version 3 of the License, or
#     (at your option) any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
# 
#     You should have received a copy of the GNU General Public License
#     along with this program.  If not, see <http://www.gnu.org/licenses/>.



from reportlab.pdfgen import  canvas
from reportlab.lib import  colors
from reportlab.platypus import Paragraph, Frame
from reportlab.lib.styles import ParagraphStyle, getSampleStyleSheet

import xml.etree.ElementTree as ET
import sys
import sqlite3
import re

MM = 0.352777778;
page = 1
out_file = "out.pdf"
db_file = "app.sqlite"
xml_file = "data.xml"


def pt(x):
    """Converte un valore in float"""
    x = float(x)
    return x / MM;

def dict_factory(cursor, row):
    '''Crea un dizionario con i nomi delle colonne presenti nelle query (tratto dal sito python.org)'''
    d = {}
    for idx, col in enumerate(cursor.description):
        d[col[0]] = row[idx]
    return d

def placeholders(s):
    '''effettua le sostituzioni di testo'''
    s = s.replace("%nrpag%", str(page)) 
    #sostituzioni da database
    if not db is None:
        for m in re.findall(r"%sql-\w*%", s):
            s = s.replace(m, db_row[m[5:-1]])
    return s

def exec_node(child):
    '''esegue la direttiva di disegno sul file PDF'''
    global page
    global db_row

    #se l'elemento non è previsto in questa pagina, passo al prossimo
    skip_page = int(child.attrib.get("skip_page", "0"))
    if page == skip_page:
        return
    
    if child.tag == "newpage":
        c.showPage()
        page += 1

    elif child.tag  == "sql_next":
        db_row = db_rset.fetchone()

    elif child.tag  == "line":
        pts = [pt(x) for x in child.attrib['coords'].split(',')]
        for i in range(0, len(pts), 4):
            c.line(pts[i]+x_delta, pts[i+1]+y_delta, pts[i+2]+x_delta, pts[i+3]+y_delta)
                       
        
    elif child.tag in ["image", "img"]:
        x = pt(child.attrib['x']) + x_delta
        y = pt(child.attrib['y']) + y_delta
        src = child.attrib['src']
        if 'width' in child.attrib.keys():
            width = pt(child.attrib['width'])
            height = pt(child.attrib['height'])
            c.drawImage(src, x, y,width=width,height=height)
        else:
            c.drawImage(src, x, y)
            
    elif child.tag == "font":
        """Font disponibili:
            Courier
            Courier-Bold
            Courier-BoldOblique
            Courier-Oblique
            Helvetica
            Helvetica-Bold
            Helvetica-BoldOblique
            Helvetica-Oblique
            Symbol
            Times-Bold
            Times-BoldItalic
            Times-Italic
            Times-Roman
            ZapfDingbats
            """
        font_name = child.attrib['name']
        font_size = int(child.attrib['size'])
        c.setFont(font_name, font_size)

    elif child.tag == "frame":
        x = pt(child.attrib['x']) + x_delta
        y = pt(child.attrib['y']) + y_delta
        width = pt(child.attrib['width'])
        height = pt(child.attrib['height'])
        boundary = int(child.attrib.get('boundary', '0'))
        f = Frame(x, y, width, height, showBoundary=boundary)
        story = []

        for subchild in child:
            if subchild.tag == "par":
                tag_start = subchild.attrib.get('tag_start', '{')
                tag_end = subchild.attrib.get('tag_end', '}')
                alignment = ["left", "center", "right"].index(subchild.attrib.get('align', 'left'))
                if alignment == -1:
                    alignment = 0

                s = subchild.text        
                if tag_start != "":
                    s = s.replace(tag_start, "<");        
                if tag_end != "":
                    s = s.replace(tag_end, ">");        
                s = placeholders(s)
                pstyle = getSampleStyleSheet()["BodyText"]
                pstyle.alignment = alignment
                story.append(Paragraph(s, pstyle))
        f.addFromList(story, c)



    elif child.tag in ["par", "paragraph"]:
        x = pt(child.attrib['x']) + x_delta
        y = pt(child.attrib['y']) + y_delta
        width = pt(child.attrib['width'])
        height = pt(child.attrib['height'])
        boundary = int(child.attrib.get('boundary', '0'))
        tag_start = child.attrib.get('tag_start', '{')
        tag_end = child.attrib.get('tag_end', '}')
        s = child.text        
        if tag_start != "":
            s = s.replace(tag_start, "<");        
        if tag_end != "":
            s = s.replace(tag_end, ">");        
        s = placeholders(s)

        f = Frame(x, y, width, height, showBoundary=boundary)
        story = []
        story.append(Paragraph(s, doc_style_body))
        f.addFromList(story, c)

    elif child.tag == "text":
        x = pt(child.attrib['x']) + x_delta
        y = pt(child.attrib['y']) + y_delta
        s = placeholders(child.text)
        text_align = child.attrib.get("align", "left")
        if text_align in ["centre", "center"]:
            c.drawCentredString(x, y, s)
        else:
            c.drawString(x, y, s)

    elif child.tag == "color":
        for key,val in child.attrib.items():
            if (key == "fill"):
                t = [float(x) / MM for x in child.attrib[key].split(',')]
                c.setFillColorRGB(*t)
            elif (key == "stroke"):
                t = [float(x) / MM for x in child.attrib[key].split(',')]
                c.setStrokeColorRGB(*t)

    elif child.tag == "rect":
        x = pt(child.attrib['x']) + x_delta
        y = pt(child.attrib['y']) + y_delta
        width = pt(child.attrib['width'])
        height = pt(child.attrib['height'])
        c.rect(x, y, width, height, fill=0)
    

#istanzio l'area di disegno
for cmdpar in sys.argv:
    if cmdpar.endswith(".sqlite"):
        db_file = cmdpar
    if cmdpar.endswith(".xml"):
        xml_file = cmdpar
    if cmdpar.endswith(".pdf"):
        out_file = cmdpar


c = canvas.Canvas(out_file, pageCompression=1)

doc_styles = getSampleStyleSheet()
doc_style_normal = doc_styles["Normal"]
doc_style_body = doc_styles["BodyText"]

#accedo al file XML contenente i dati da processare
xdoc = ET.parse(xml_file)
xroot = xdoc.getroot()          #nodo principale
xhead = xroot.find('header')    #nodo con tutti gli elementi fissi su ogni pagina
xsql = xroot.find('sqlite')     #nodo con tutti gli elementi relativi al database

db = None
db_cols = None
db_cursor = None

x_delta = 0
y_delta = 0

if (xsql != None):
    db = sqlite3.connect(db_file)
    db.row_factory = dict_factory   
    db_cursor = db.cursor()
    db_rset = db.execute(xsql.attrib['sql'])
    
    db_first_element = True
    
    db_row = db_rset.fetchone()
    while not db_row is None:
        #creo la pagina successiva (tranne per il primo record)        
        if not db_first_element:
            c.showPage()
            page += 1
                    
        #metto le intestazioni (prima pagina)        
        if xhead != None:
                for child in xhead:
                    exec_node(child)

        for child in xroot:
            if child.tag == "repeat":
                rep_x = int(child.attrib.get("x_count", 0))
                rep_x_dist = int(pt(child.attrib.get("x", 0)))
                rep_y = int(child.attrib.get("y_count", 0))
                rep_y_dist = int(pt(child.attrib.get("y", 0)))
                for y_delta in range(0, rep_y * rep_y_dist, rep_y_dist):
                    for x_delta in range(0, rep_x * rep_x_dist, rep_x_dist):
                        if db_row is None:
                            break                       
                        for subchild in child:
                            exec_node(subchild)
                x_delta = 0
                y_delta = 0


            elif child.tag == "newpage":
                #creo la pagina N nel contesto del record attuale (metto nuovamente le intestazioni)            
                exec_node(child)
                if xhead != None:
                    for child in xhead:
                        exec_node(child)
            else:
                #creo i contenuti nella pagina corrente        
                exec_node(child)
            #sono finiti i record, esco            
            if db_row is None:
                break

        db_first_element = False

        #sono finiti i record, esco            
        if db_row is None:
            break

        #passo al prossimo record        
        db_row = db_rset.fetchone()


else:
    if xhead != None:
        for child in xhead:
            exec_node(child)

    for child in xroot:
        if child.tag == "newpage":
            exec_node(child)
            if xhead != None:
                for child in xhead:
                    exec_node(child)
        else:
            exec_node(child)

c.save()
